/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.mixins;

import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import dev.lopyluna.dndesires.content.propagators.RotationPropagation;
import dev.lopyluna.dndesires.content.propagators.RotationPropagationRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RotationPropagator.class}, remap=false)
public class RotationPropagatorMixin {
    @Inject(method={"getRotationSpeedModifier"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectSpeedModifier(KineticBlockEntity from, KineticBlockEntity to, CallbackInfoReturnable<Float> cir) {
        Float result;
        RotationPropagation handler = RotationPropagationRegistry.get(from);
        if (handler != null && (result = handler.getRotationSpeedModifier(from, to)) != null) {
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"getConveyedSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectConveyedSpeed(KineticBlockEntity from, KineticBlockEntity to, CallbackInfoReturnable<Float> cir) {
        Float result;
        RotationPropagation handler = RotationPropagationRegistry.get(from);
        if (handler != null && (result = handler.getConveyedSpeed(from, to)) != null) {
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"propagateNewSource"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectPropagateNewSource(KineticBlockEntity currentTE, CallbackInfo ci) {
        RotationPropagation handler = RotationPropagationRegistry.get(currentTE);
        if (handler != null && handler.propagateNewSource(currentTE)) {
            ci.cancel();
        }
    }

    @Inject(method={"handleRemoved"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectHandleRemoved(Level worldIn, BlockPos pos, KineticBlockEntity removedBE, CallbackInfo ci) {
        RotationPropagation handler = RotationPropagationRegistry.get(removedBE);
        if (handler != null && handler.handleRemoved(worldIn, pos, removedBE)) {
            ci.cancel();
        }
    }

    @Inject(method={"getPotentialNeighbourLocations"}, at={@At(value="RETURN")}, cancellable=true)
    private static void injectPotentialNeighbours(KineticBlockEntity be, CallbackInfoReturnable<List<BlockPos>> cir) {
        List<BlockPos> result;
        RotationPropagation handler = RotationPropagationRegistry.get(be);
        if (handler != null && (result = handler.getPotentialNeighbourLocations(be, (List)cir.getReturnValue())) != null) {
            cir.setReturnValue(result);
        }
    }
}

